/*
 *	lbp-if.c --- "if" filter for LIPS2, invoked by lpd.
 *
 *			Copyright (C) 1994,1996 Koh-ichi Ito
 */

#include <stdio.h>
#include <syslog.h>
#include <signal.h>
#include "config.h"
#define INDENT	  0
#define TABS	  8
#define BS	0x08
#define TAB	0x09
#define FF	0x0c
#define ESC	0x1b

#define SI	putchar(0x0f)
#define SO	printf("\033n")

#define SJIS	1
#define JIS	2
#define EUC	3

void	preamble();
void	postamble();
void	deadcopy();
void	abort();
void	sjis2jis();

struct args {
	int	c;	/* include ctrl chrs */
	int	width;
	int	length;
	int	indent;
	char	*name;
	char	*host;
	char	*acct;
};

char	*MyName;
struct args	Args = {
		0, WIDTH, LENGTH, INDENT, NULL, NULL, NULL};
int	Page;
static char	Header[] = "$Header: /home/alphonse/kohi/src/lbp-if/RCS/lbp-if.c,v 1.9 1999/09/07 05:23:41 kohi Exp $";

main(argc, argv)

	int	argc;
	char	**argv;
{
	signal(SIGINT, abort);
	MyName = *argv;
	while (--argc) {
		if (**++argv != '-') {
			break;
		}
		switch (*++*argv) {
		case 'c':
			Args.c = 1;
			break;
		case 'w':
			Args.width = atoi(++*argv);
			break;
		case 'l':
			Args.length = atoi(++*argv);
			break;
		case 'i':
			Args.indent = atoi(++*argv);
			break;
		case 'n':
			Args.name = *++argv;
			argc--;
			break;
		case 'h':
			Args.host = *++argv;
			argc--;
			break;
		default:
			break;
		}
	}
	if (argc) {
		Args.acct = *argv;
	}
	if (Args.c) {
		deadcopy();
		acct();
		exit(0);
	}
#ifdef REJECT_PS
	reject_ps();
#endif
	preamble();
	Page = 0;
	while (++Page, print_a_page() )
		;
	postamble();
	acct();
	exit(0);
}

int print_a_page()
{
	int	x, y, l, tabs;
	static int kanji = 0;
	int	c, c2;

	l = Args.width - Args.indent;
	for (y = 0; y < Args.length; y++) {
		for (x = 0; x < Args.indent + L_MARGIN; x++) {
			putchar(' ');
		}
		if (kanji) {
			SO;
		}
		x = 0;
		while (x < l) {
			c = getchar();
			switch (c) {
			case EOF:
				return 0;
			case FF:
				c = getchar();
				if (c == EOF) {
					return 0;
				}
				ungetc(c, stdin);
				if (kanji) {
					kanji = 0;
					SI;
				}
				putchar('\r');
				putchar(FF);
				return 1;
			case '\031':
				/*
				 * when invoked as 'of',
				 * lpd request to stop 'of'
				 * by the sequence of '\031\1'.
				 */
				c = getchar();
				if (c == '\1') {
					putchar(FF);
					fflush(stdout);
					kill(getpid(), SIGSTOP);
					return 1;
				} else {
					ungetc(c, stdin);
					ungetc('\031', stdin);
				}
				break;
			case '\r':
				c = getchar();
				if (c == '\n') {
					goto EOLN;
				} else {
					ungetc(c, stdin);
					if (kanji) {
						kanji = 0;
						SI;
					}
					putchar('\r');
					for (x = 0; x < Args.indent
							+ L_MARGIN; x++) {
						putchar(' ');
					}
					continue;
				}
			case '\n':
				goto EOLN;
			case '\t':
				tabs = (int)( (x + TABS) / TABS) * TABS;
				if (l < tabs) {
					goto EOLN;
				}
				if (kanji) {
					kanji = 0;
					SI;
				}
				while (x < tabs) {
					putchar(' ');
					x++;
				}
				break;
			case ESC:
				c = getchar();
				if (c == '$') {
					kanji = JIS;
					getchar();	/* skip 1 char */
					SO;
					break;
				} else if (c == '(') {	/* ) */
					kanji = 0;
					getchar();	/* skip 1 char */
					SI;
					break;
				} else {
					putchar(ESC);
					putchar(c);
					x += 2;
					break;
				}
			default:
#ifdef USE_EUC
				if ( (kanji != EUC) && (c & 0x80) ) {
					kanji = EUC;
					SO;
				} else if ( (kanji == EUC)
					&& !(c & 0x80) ) {
					kanji = 0;
					SI;
				}
#else	/* USE_EUC */
				if ( (kanji != SJIS) && (c & 0x80) ) {
					kanji = SJIS;
					SO;
				} else if ( (kanji == SJIS)
					&& !(c & 0x80) ) {
					kanji = 0;
					SI;
				}
#endif	/* USE_EUC */
				if (kanji) {
					if (x == l - 1) {
						ungetc(c, stdin);
						goto EOLN;
					}
					c2 = getchar();
#ifndef USE_EUC
					if (kanji == SJIS) {
						sjis2jis(&c, &c2);
					}
#endif
					putchar(c & 0x7f);
					putchar(c2 & 0x7f);
					x += 2;
				} else {
					putchar(c);
					if (c == BS) {
						x--;
					} else {
						x++;
					}
				}
				break;
			}
		}
EOLN:
		if (kanji) {
			SI;
		}
		if (l <= x) {
			c = getchar();
			if (c != '\n') {
				ungetc(c, stdin);
			}
		}
		putchar('\n');
	}
	putchar(FF);
	return 1;
}

void preamble()
{
	printf("\033%%@");			/* text mode */
#ifdef FEED
	printf("\033[%sq", FEED);		/* ] set paper feed */
#endif
#ifdef PAGE_FORMAT
	printf("\033[%sp", PAGE_FORMAT);	/* ] set page format */
#endif
	printf("\033P21;240;1J\033\\");		/* start job */
	printf("\033<");			/* soft reset */
	printf("\033[?5h");			/* ] auto CR by LF */
	printf("\033[?2h");			/* ] no auto FF */
	printf("\033[2 I");			/* ] set size unit 0.1pt */
	SI;
	printf("\033[%s K", CHAR_PITCH);	/* ] */
	printf("\033[%s C", CHAR_SIZE);		/* ] */
	SO;
	printf("\033[%s K", CHAR_PITCH2);	/* ] */
	printf("\033[%s C", CHAR_SIZE);		/* ] */
	SI;
	printf("\033[%s L", LINE_PITCH);	/* ] */
}

void postamble()
{
	putchar(FF);
	printf("\033P0J\033\\");	/* end job */
}

void deadcopy()
{
	int	c;

	while ( (c = getchar() ) != EOF) {
		putchar(c);
	}
}

void abort()
{
	printf("\033<");
	postamble();
	acct();
	exit(0);
}

int acct()
{
	FILE	*fp;

	if (!Args.acct) {
		return 1;
	}
	if ( (fp = fopen(Args.acct, "a") ) == NULL) {
		fprintf(stderr, "%s: ", MyName);
		perror(Args.acct);
		return 0;
	}
#ifdef ACCT_BC
	fprintf(fp, "%s @ %s prints %d page(s)\n", Args.name,
		Args.host, Page);
#else
	fprintf(fp, "%d\t%s:%s\n", Page, Args.host, Args.name);
#endif
	fclose(fp);
	return 1;
}

#ifdef REJECT_PS
int reject_ps()
{
	char	hdr[2];
#ifdef NOTIFY_MAIL
	char	mail_cmd[100];
	FILE	*mail;
#endif	/* NOFIFY_MAIL */

	hdr[0] = getchar();
	hdr[1] = getchar();
	if ( (hdr[0] == '%') && (hdr[1] == '!') ) {
		fprintf(stderr,
			"%s's job seems to be a Postscript\n",
			Args.name);
#ifdef NOTIFY_MAIL
#ifdef MAIL_TO_LOCAL
		sprintf(mail_cmd, "%s %s", MAIL_CMD, Args.name);
#endif	/* MAIL_TO_LOCAL */
#ifdef MAIL_TO_CLIENT
		sprintf(mail_cmd, "%s %s@%s",
			MAIL_CMD, Args.name, Args.host);
#endif	/* MAIL_TO_CLIENT */
#ifdef MAIL_TO_HUB
		sprintf(mail_cmd, "%s %s@%s",
			MAIL_CMD, Args.name, MAIL_HUB);
#endif	/* MAIL_TO_HUB */
		if ( (mail = popen(mail_cmd, "w") ) == NULL) {
			perror(MyName);
		} else {
			fputs("~s Postscript is rejected\n", mail);
			fputs("Hello, This is daemon@printer sesrver.\n\n",
				mail);
			fputs("Your print job looks like Postscript.\n",
				mail);
			fputs("If you really want to print it as a plain text,\n", mail);
			fputs("use '-l' option on lpr,\n", mail);
			fputs("\n\tlpr -l file...\n\n", mail);
			fputs("Or resend the job to a Postscript printer.\n",
				mail);
			pclose(mail);
		}
#endif	/* NOTIFY_MAIL */
		exit(2);
	}
	ungetc(hdr[1], stdin);
	ungetc(hdr[0], stdin);
	/* bad in the case EOF occure in hdr[0] or hdr[1] */
	return 1;
}
#endif	/* REJECT_PS */

#ifndef USE_EUC
void sjis2jis(c1, c2)

	int	*c1, *c2;
{
	if (0x9f < *c1) {
		*c1 -= 0xb1;
	} else {
		*c1 -= 0x71;
	}
	*c1 = *c1 * 2 + 1;
	if (0x9f < *c2) {
		*c2 = *c2 - 0x7e;
		(*c1)++;
	} else if (0x7e < *c2) {
		*c2 -= 0x20;
	} else {
		*c2 -= 0x1f;
	}
}
#endif	/* USE_EUC */
